Attribute VB_Name = "MdlIniFileXtal"
Option Explicit

Private Const MAX_PATH = 260
Private Const INI_FILE As String = ".\Xtal.ini"

'**************************
' tuning fork crystal unit
'**************************
Private Const APP_NAME_XTAL As String = "XTAL"
Private Const KEY_XTAL_FREQ As String = "FREQ"
Private Const DEF_XTAL_FREQ As String = "32768" 'Hz '"32.768" 'kHz

Private Const KEY_XTAL_CAP As String = "CAP"
Private Const DEF_XTAL_CAP As String = "12.5"

Private Const KEY_XTAL_CI As String = "TypCI"
Private Const DEF_XTAL_CI As String = "50000"

'****************************
' Xtal
'****************************
Private Const KEY_XTAL_C0FRQ As String = "C0_FREQ"
Private Const DEF_XTAL_C0FRQ As String = "31000" 'Hz '"31" 'kHz

Private Const KEY_XTAL_C0SPN As String = "C0_SPAN"
Private Const DEF_XTAL_C0SPN As String = "0"

Private Const KEY_XTAL_C0PNT As String = "C0_POINT"
Private Const DEF_XTAL_C0PNT As String = "1"

Private Const KEY_XTAL_C0LVL As String = "C0_LEVEL"
Private Const DEF_XTAL_C0LVL As String = "0.1"      ' uW

Private Const KEY_XTAL_C0RBW As String = "C0_RBW"
Private Const DEF_XTAL_C0RBW As String = "300"

Private Const KEY_XTAL_C0TIM As String = "C0_TIME"
Private Const DEF_XTAL_C0TIM As String = "50"

Private Const KEY_XTAL_OTFRQ As String = "OT_FREQ"
Private Const DEF_XTAL_OTFRQ As String = "32768" 'Hz '"32.768" 'kHz

Private Const KEY_XTAL_OTSPN As String = "OT_SPAN"
Private Const DEF_XTAL_OTSPN As String = "50"

Private Const KEY_XTAL_OTPNT As String = "OT_POINT"
Private Const DEF_XTAL_OTPNT As String = "51"

Private Const KEY_XTAL_OTLVL As String = "OT_LEVEL"
Private Const DEF_XTAL_OTLVL As String = "0.1"      ' uW

Private Const KEY_XTAL_OTRBW As String = "OT_RBW"
Private Const DEF_XTAL_OTRBW As String = "300"

Private Const KEY_XTAL_OTTIM As String = "OT_TIME"
Private Const DEF_XTAL_OTTIM As String = "50"

Private Const KEY_XTAL_FLFRQ As String = "FL_FREQ"
Private Const DEF_XTAL_FLFRQ As String = DEF_XTAL_FREQ

Private Const KEY_XTAL_FLSPN As String = "FL_SPAN"
Private Const DEF_XTAL_FLSPN As String = "10"

Private Const KEY_XTAL_FLPNT As String = "FL_POINT"
Private Const DEF_XTAL_FLPNT As String = "11"

Private Const KEY_XTAL_FLLVL As String = "FL_LEVEL"
Private Const DEF_XTAL_FLLVL As String = "0.1"      ' uW

Private Const KEY_XTAL_FLRBW As String = "FL_RBW"
Private Const DEF_XTAL_FLRBW As String = "300"

Private Const KEY_XTAL_FLTIM As String = "FL_TIME"
Private Const DEF_XTAL_FLTIM As String = "50"

Private Const KEY_XTAL_CAFRQ As String = "CAL_FREQ"
Private Const DEF_XTAL_CAFRQ As String = DEF_XTAL_OTFRQ

Private Const KEY_XTAL_CASPN As String = "CAL_SPAN"
Private Const DEF_XTAL_CASPN As String = "300"

Private Const KEY_XTAL_CAPNT As String = "CAL_POINT"
Private Const DEF_XTAL_CAPNT As String = "201"

Private Const KEY_XTAL_CALVL As String = "CAL_LEVEL"
Private Const DEF_XTAL_CALVL As String = "0.1"      ' uW

Private Const KEY_XTAL_CARBW As String = "CAL_RBW"
Private Const DEF_XTAL_CARBW As String = "100"

Private Const KEY_XTAL_CATIM As String = "CAL_TIME"
Private Const DEF_XTAL_CATIM As String = "50"

'**** Cal Kit ****
Private Const KEY_XTAL_OPN_R As String = "OPEN_Rs"
Private Const DEF_XTAL_OPN_R As String = "1000000000"

Private Const KEY_XTAL_OPN_L As String = "OPEN_Ls"
Private Const DEF_XTAL_OPN_L As String = "0"

Private Const KEY_XTAL_OPN_C As String = "OPEN_Cap"
Private Const DEF_XTAL_OPN_C As String = "0"

Private Const KEY_XTAL_SHT_R As String = "SHORT_Rs"
Private Const DEF_XTAL_SHT_R As String = "10000"

Private Const KEY_XTAL_SHT_L As String = "SHORT_Ls"
Private Const DEF_XTAL_SHT_L As String = "0"

Private Const KEY_XTAL_SHT_C As String = "SHORT_Cap"
Private Const DEF_XTAL_SHT_C As String = "0"

Private Const KEY_XTAL_LOD_R As String = "LOAD_Rs"
Private Const DEF_XTAL_LOD_R As String = "1000000"

Private Const KEY_XTAL_LOD_L As String = "LOAD_Ls"
Private Const DEF_XTAL_LOD_L As String = "0"

Private Const KEY_XTAL_LOD_C As String = "LOAD_Cap"
Private Const DEF_XTAL_LOD_C As String = "0"

'**** Measurement Result Limit Upper Limit ****
' C0
Private Const KEY_XTAL_C0_UP As String = "UPPER_LMT_C0"
Private Const DEF_XTAL_C0_UP As String = "0"
' C1
Private Const KEY_XTAL_C1_UP As String = "UPPER_LMT_C1"
Private Const DEF_XTAL_C1_UP As String = "0"
' L1
Private Const KEY_XTAL_L1_UP As String = "UPPER_LMT_L1"
Private Const DEF_XTAL_L1_UP As String = "0"
' R1
Private Const KEY_XTAL_R1_UP As String = "UPPER_LMT_R1"
Private Const DEF_XTAL_R1_UP As String = "0"
' Q
Private Const KEY_XTAL_Q__UP As String = "UPPER_LMT__Q"
Private Const DEF_XTAL_Q__UP As String = "0"
' Fr
Private Const KEY_XTAL_Fr_UP As String = "UPPER_LMT_Fr"
Private Const DEF_XTAL_Fr_UP As String = "0"
' CI
Private Const KEY_XTAL_CI_UP As String = "UPPER_LMT_CI"
Private Const DEF_XTAL_CI_UP As String = "0"
' FL
Private Const KEY_XTAL_FL_UP As String = "UPPER_LMT_FL"
Private Const DEF_XTAL_FL_UP As String = "0"

'**** Measurement Result Limit Lower Limit ****
' C0
Private Const KEY_XTAL_C0_LW As String = "LOWER_LMT_C0"
Private Const DEF_XTAL_C0_LW As String = "0"
' C1
Private Const KEY_XTAL_C1_LW As String = "LOWER_LMT_C1"
Private Const DEF_XTAL_C1_LW As String = "0"
' L1
Private Const KEY_XTAL_L1_LW As String = "LOWER_LMT_L1"
Private Const DEF_XTAL_L1_LW As String = "0"
' R1
Private Const KEY_XTAL_R1_LW As String = "LOWER_LMT_R1"
Private Const DEF_XTAL_R1_LW As String = "0"
' Q
Private Const KEY_XTAL_Q__LW As String = "LOWER_LMT__Q"
Private Const DEF_XTAL_Q__LW As String = "0"
' Fr
Private Const KEY_XTAL_Fr_LW As String = "LOWER_LMT_Fr"
Private Const DEF_XTAL_Fr_LW As String = "0"
' CI
Private Const KEY_XTAL_CI_LW As String = "LOWER_LMT_CI"
Private Const DEF_XTAL_CI_LW As String = "0"
' FL
Private Const KEY_XTAL_FL_LW As String = "LOWER_LMT_FL"
Private Const DEF_XTAL_FL_LW As String = "0"

'**** Measurement uW To dBm Change paramter ****
' System-of-measurement impedance
Private Const KEY_XTAL_IMP As String = "IMPEDANCE"
Private Const DEF_XTAL_IMP As String = "2000000"
' The profit of amp.
Private Const KEY_XTAL_AMP As String = "PROFIT_AMP"
Private Const DEF_XTAL_AMP As String = "45.5625"

'*******************************************************************
' Writes tuning fork crystal unit Nominal frequency in Xtal.ini.
'*******************************************************************
Public Sub WriteIniFile_XtalNominalFreq(ByVal strFreq As String)
    Dim ret As Long
    ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_FREQ, strFreq, INI_FILE)
End Sub

'*******************************************************************
' Reads tuning fork crystal unit Nominal frequency in Xtal.ini.
'*******************************************************************
Public Function ReadIniFile_XtalNominalFreq() As String
    Dim strFreq As String
    Dim ret As Long
    
    strFreq = "                "
    ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_FREQ, DEF_XTAL_FREQ, strFreq, Len(strFreq), INI_FILE)
    ReadIniFile_XtalNominalFreq = strFreq
End Function

'*******************************************************************
' Writes tuning fork crystal unit Load capacitance in Xtal.ini.
'*******************************************************************
Public Sub WriteIniFile_XtalLoadCap(ByVal strCap As String)
    Dim ret As Long
    ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CAP, strCap, INI_FILE)
End Sub

'*******************************************************************
' Reads tuning fork crystal unit Load capacitance in Xtal.ini.
'*******************************************************************
Public Function ReadIniFile_XtalLoadCap() As String
    Dim strCap As String
    Dim ret As Long
    
    strCap = "                "
    ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CAP, DEF_XTAL_CAP, strCap, Len(strCap), INI_FILE)
    ReadIniFile_XtalLoadCap = strCap
End Function

'*********************************************************
' Writes tuning fork crystal unit Typ.CI in Xtal.ini.
'*********************************************************
Public Sub WriteIniFile_XtalTypCI(ByVal strCI As String)
    Dim ret As Long
    ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CI, strCI, INI_FILE)
End Sub

'********************************************************
' Reads tuning fork crystal unit Typ.CI in Xtal.ini.
'********************************************************
Public Function ReadIniFile_XtalTypCI() As String
    Dim strCI As String
    Dim ret As Long
    
    strCI = "                "
    ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CI, DEF_XTAL_CI, strCI, Len(strCI), INI_FILE)
    ReadIniFile_XtalTypCI = strCI
End Function

'******************************************************************
' Writes tuning fork crystal unit C0 / other / FL in Xtal.ini.
'******************************************************************
Public Sub WriteIniFile_XtalIni(ByVal idx As Integer, ByVal strRtn As String)
    Dim ret As Long

' Center Freq
    If idx = DEV_C0C_Index Then
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_C0FRQ, strRtn, INI_FILE)
    ElseIf idx = DEV_OTC_Index Then
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OTFRQ, strRtn, INI_FILE)
    ElseIf idx = DEV_FLC_Index Then
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_FLFRQ, strRtn, INI_FILE)
    ElseIf idx = DEV_CAC_Index Then
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CAFRQ, strRtn, INI_FILE)
' Span
    ElseIf idx = DEV_C0S_Index Then
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_C0SPN, strRtn, INI_FILE)
    ElseIf idx = DEV_OTS_Index Then
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OTSPN, strRtn, INI_FILE)
    ElseIf idx = DEV_FLS_Index Then
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_FLSPN, strRtn, INI_FILE)
    ElseIf idx = DEV_CAS_Index Then
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CASPN, strRtn, INI_FILE)
' Points
    ElseIf idx = DEV_C0P_Index Then
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_C0PNT, strRtn, INI_FILE)
    ElseIf idx = DEV_OTP_Index Then
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OTPNT, strRtn, INI_FILE)
    ElseIf idx = DEV_FLP_Index Then
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_FLPNT, strRtn, INI_FILE)
    ElseIf idx = DEV_CAP_Index Then
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CAPNT, strRtn, INI_FILE)
' Level of drive
    ElseIf idx = DEV_C0L_Index Then
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_C0LVL, strRtn, INI_FILE)
    ElseIf idx = DEV_OTL_Index Then
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OTLVL, strRtn, INI_FILE)
    ElseIf idx = DEV_FLL_Index Then
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_FLLVL, strRtn, INI_FILE)
    ElseIf idx = DEV_CAL_Index Then
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CALVL, strRtn, INI_FILE)
' RBW
    ElseIf idx = DEV_C0R_Index Then
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_C0RBW, strRtn, INI_FILE)
    ElseIf idx = DEV_OTR_Index Then
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OTRBW, strRtn, INI_FILE)
    ElseIf idx = DEV_FLR_Index Then
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_FLRBW, strRtn, INI_FILE)
    ElseIf idx = DEV_CAR_Index Then
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CARBW, strRtn, INI_FILE)
' Settling Time
    ElseIf idx = DEV_C0T_Index Then
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_C0TIM, strRtn, INI_FILE)
    ElseIf idx = DEV_OTT_Index Then
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OTTIM, strRtn, INI_FILE)
    ElseIf idx = DEV_FLT_Index Then
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_FLTIM, strRtn, INI_FILE)
    ElseIf idx = DEV_CAT_Index Then
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CATIM, strRtn, INI_FILE)
    End If

End Sub

'*****************************************************************
' Reads tuning fork crystal unit C0 / other / FL in Xtal.ini.
'*****************************************************************
Public Function ReadIniFile_XtalIni(ByVal idx As Integer) As String
    Dim strRtn As String
    Dim ret As Long
    
    strRtn = "                           "

' Center Freq
    If idx = DEV_C0C_Index Then
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_C0FRQ, DEF_XTAL_C0FRQ, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = DEV_OTC_Index Then
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OTFRQ, DEF_XTAL_OTFRQ, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = DEV_FLC_Index Then
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_FLFRQ, DEF_XTAL_FLFRQ, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = DEV_CAC_Index Then
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CAFRQ, DEF_XTAL_CAFRQ, strRtn, Len(strRtn), INI_FILE)
' Span
    ElseIf idx = DEV_C0S_Index Then
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_C0SPN, DEF_XTAL_C0SPN, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = DEV_OTS_Index Then
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OTSPN, DEF_XTAL_OTSPN, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = DEV_FLS_Index Then
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_FLSPN, DEF_XTAL_FLSPN, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = DEV_CAS_Index Then
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CASPN, DEF_XTAL_CASPN, strRtn, Len(strRtn), INI_FILE)
' Points
    ElseIf idx = DEV_C0P_Index Then
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_C0PNT, DEF_XTAL_C0PNT, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = DEV_OTP_Index Then
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OTPNT, DEF_XTAL_OTPNT, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = DEV_FLP_Index Then
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_FLPNT, DEF_XTAL_FLPNT, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = DEV_CAP_Index Then
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CAPNT, DEF_XTAL_CAPNT, strRtn, Len(strRtn), INI_FILE)
' Level of drive
    ElseIf idx = DEV_C0L_Index Then
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_C0LVL, DEF_XTAL_C0LVL, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = DEV_OTL_Index Then
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OTLVL, DEF_XTAL_OTLVL, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = DEV_FLL_Index Then
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_FLLVL, DEF_XTAL_FLLVL, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = DEV_CAL_Index Then
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CALVL, DEF_XTAL_CALVL, strRtn, Len(strRtn), INI_FILE)
' RBW
    ElseIf idx = DEV_C0R_Index Then
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_C0RBW, DEF_XTAL_C0RBW, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = DEV_OTR_Index Then
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OTRBW, DEF_XTAL_OTRBW, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = DEV_FLR_Index Then
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_FLRBW, DEF_XTAL_FLRBW, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = DEV_CAR_Index Then
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CARBW, DEF_XTAL_CARBW, strRtn, Len(strRtn), INI_FILE)
' Settling Time
    ElseIf idx = DEV_C0T_Index Then
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_C0TIM, DEF_XTAL_C0TIM, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = DEV_OTT_Index Then
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OTTIM, DEF_XTAL_OTTIM, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = DEV_FLT_Index Then
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_FLTIM, DEF_XTAL_FLTIM, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = DEV_CAT_Index Then
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CATIM, DEF_XTAL_CATIM, strRtn, Len(strRtn), INI_FILE)
    End If
    
    ReadIniFile_XtalIni = strRtn
End Function

'******************************************************************
' Writes tuning fork crystal Calibration Kit in Xtal.ini.
'******************************************************************
Public Sub WriteIniFile_XtalCal(ByVal idx As Integer, ByVal strRtn As String)
    Dim ret As Long

' OPEN
    If idx = DEV_ORS_Index Then
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OPN_R, strRtn, INI_FILE)
    ElseIf idx = DEV_OLS_Index Then
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OPN_L, strRtn, INI_FILE)
    ElseIf idx = DEV_OCP_Index Then
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OPN_C, strRtn, INI_FILE)
' SHORT
    ElseIf idx = DEV_SRS_Index Then
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_SHT_R, strRtn, INI_FILE)
    ElseIf idx = DEV_SLS_Index Then
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_SHT_L, strRtn, INI_FILE)
    ElseIf idx = DEV_SCP_Index Then
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_SHT_C, strRtn, INI_FILE)
' LOAD
    ElseIf idx = DEV_LRS_Index Then
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_LOD_R, strRtn, INI_FILE)
    ElseIf idx = DEV_LLS_Index Then
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_LOD_L, strRtn, INI_FILE)
    ElseIf idx = DEV_LCP_Index Then
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_LOD_C, strRtn, INI_FILE)
    End If
    
End Sub

'*****************************************************************
' Reads tuning fork crystal unit Calibration Kit in Xtal.ini.
'*****************************************************************
Public Function ReadIniFile_XtalCal(ByVal idx As Integer) As String
    Dim strRtn As String
    Dim ret As Long
    
    strRtn = "                           "

' OPEN
    If idx = DEV_ORS_Index Then
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OPN_R, DEF_XTAL_OPN_R, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = DEV_OLS_Index Then
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OPN_L, DEF_XTAL_OPN_L, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = DEV_OCP_Index Then
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OPN_C, DEF_XTAL_OPN_C, strRtn, Len(strRtn), INI_FILE)
' SHORT
    ElseIf idx = DEV_SRS_Index Then
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_SHT_R, DEF_XTAL_SHT_R, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = DEV_SLS_Index Then
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_SHT_L, DEF_XTAL_SHT_L, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = DEV_SCP_Index Then
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_SHT_C, DEF_XTAL_SHT_C, strRtn, Len(strRtn), INI_FILE)
' LOAD
    ElseIf idx = DEV_LRS_Index Then
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_LOD_R, DEF_XTAL_LOD_R, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = DEV_LLS_Index Then
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_LOD_L, DEF_XTAL_LOD_L, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = DEV_LCP_Index Then
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_LOD_C, DEF_XTAL_LOD_C, strRtn, Len(strRtn), INI_FILE)
    End If
    
    ReadIniFile_XtalCal = strRtn
End Function

'************************************************************************
' Writes tuning fork crystal Measurement Result Upper Limit in Xtal.ini.
'************************************************************************
Public Sub WriteIniFile_XtalUpLimit(ByVal idx As Integer, ByVal strRtn As String)
    Dim ret As Long

    If idx = LMT_C0_Index Then
' C0
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_C0_UP, strRtn, INI_FILE)
    ElseIf idx = LMT_C1_Index Then
' C1
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_C1_UP, strRtn, INI_FILE)
    ElseIf idx = LMT_L1_Index Then
' L1
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_L1_UP, strRtn, INI_FILE)
    ElseIf idx = LMT_R1_Index Then
' R1
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_R1_UP, strRtn, INI_FILE)
    ElseIf idx = LMT_Q__Index Then
' Q
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_Q__UP, strRtn, INI_FILE)
    ElseIf idx = LMT_Fr_Index Then
' Fr
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_Fr_UP, strRtn, INI_FILE)
    ElseIf idx = LMT_CI_Index Then
' CI
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CI_UP, strRtn, INI_FILE)
    ElseIf idx = LMT_FL_Index Then
' FL
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_FL_UP, strRtn, INI_FILE)
    End If
    
End Sub

'***********************************************************************
' Reads tuning fork crystal Measurement Result Upper Limit in Xtal.ini.
'***********************************************************************
Public Function ReadIniFile_XtalUpLimit(ByVal idx As Integer) As String
    Dim strRtn As String
    Dim ret As Long
    
    strRtn = "                           "

    If idx = LMT_C0_Index Then
' C0
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_C0_UP, DEF_XTAL_C0_UP, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = LMT_C1_Index Then
' C1
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_C1_UP, DEF_XTAL_C1_UP, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = LMT_L1_Index Then
' L1
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_L1_UP, DEF_XTAL_L1_UP, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = LMT_R1_Index Then
' R1
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_R1_UP, DEF_XTAL_R1_UP, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = LMT_Q__Index Then
' Q
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_Q__UP, DEF_XTAL_Q__UP, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = LMT_Fr_Index Then
' Fr
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_Fr_UP, DEF_XTAL_Fr_UP, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = LMT_CI_Index Then
' CI
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CI_UP, DEF_XTAL_CI_UP, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = LMT_FL_Index Then
' FL
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_FL_UP, DEF_XTAL_FL_UP, strRtn, Len(strRtn), INI_FILE)
    End If
    
    ReadIniFile_XtalUpLimit = strRtn
End Function

'************************************************************************
' Writes tuning fork crystal Measurement Result Lower Limit in Xtal.ini.
'************************************************************************
Public Sub WriteIniFile_XtalLwLimit(ByVal idx As Integer, ByVal strRtn As String)
    Dim ret As Long

    If idx = LMT_C0_Index Then
' C0
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_C0_LW, strRtn, INI_FILE)
    ElseIf idx = LMT_C1_Index Then
' C1
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_C1_LW, strRtn, INI_FILE)
    ElseIf idx = LMT_L1_Index Then
' L1
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_L1_LW, strRtn, INI_FILE)
    ElseIf idx = LMT_R1_Index Then
' R1
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_R1_LW, strRtn, INI_FILE)
    ElseIf idx = LMT_Q__Index Then
' Q
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_Q__LW, strRtn, INI_FILE)
    ElseIf idx = LMT_Fr_Index Then
' Fr
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_Fr_LW, strRtn, INI_FILE)
    ElseIf idx = LMT_CI_Index Then
' CI
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CI_LW, strRtn, INI_FILE)
    ElseIf idx = LMT_FL_Index Then
' FL
        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_FL_LW, strRtn, INI_FILE)
    End If
    
End Sub

'***********************************************************************
' Reads tuning fork crystal Measurement Result Upper Limit in Xtal.ini.
'***********************************************************************
Public Function ReadIniFile_XtalLwLimit(ByVal idx As Integer) As String
    Dim strRtn As String
    Dim ret As Long
    
    strRtn = "                           "

    If idx = LMT_C0_Index Then
' C0
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_C0_LW, DEF_XTAL_C0_LW, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = LMT_C1_Index Then
' C1
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_C1_LW, DEF_XTAL_C1_LW, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = LMT_L1_Index Then
' L1
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_L1_LW, DEF_XTAL_L1_LW, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = LMT_R1_Index Then
' R1
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_R1_LW, DEF_XTAL_R1_LW, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = LMT_Q__Index Then
' Q
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_Q__LW, DEF_XTAL_Q__LW, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = LMT_Fr_Index Then
' Fr
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_Fr_LW, DEF_XTAL_Fr_LW, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = LMT_CI_Index Then
' CI
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CI_LW, DEF_XTAL_CI_LW, strRtn, Len(strRtn), INI_FILE)
    ElseIf idx = LMT_FL_Index Then
' FL
        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_FL_LW, DEF_XTAL_FL_LW, strRtn, Len(strRtn), INI_FILE)
    End If
    
    ReadIniFile_XtalLwLimit = strRtn
End Function


'*************************************************************************
' Writes tuning fork crystal measurement calculate impedance in Xtal.ini.
'*************************************************************************
Public Sub WriteIniFile_XtalImpedance(ByVal strRtn As String)
    Dim ret As Long

    ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_IMP, strRtn, INI_FILE)
End Sub

'************************************************************************
' Reads tuning fork crystal measurement calculate impedance in Xtal.ini.
'************************************************************************
Public Function ReadIniFile_XtalImpedance() As String
    Dim strRtn As String
    Dim ret As Long
    
    strRtn = "                           "

    ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_IMP, DEF_XTAL_IMP, strRtn, Len(strRtn), INI_FILE)
    ReadIniFile_XtalImpedance = strRtn

End Function


'*******************************************************************
' Writes tuning fork crystal measurement profit of amp in Xtal.ini.
'*******************************************************************
Public Sub WriteIniFile_XtalProfitOfAmp(ByVal strRtn As String)
    Dim ret As Long

    ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_AMP, strRtn, INI_FILE)
End Sub

'*******************************************************************
' Reads tuning fork crystal measurement profit of amp in Xtal.ini.
'*******************************************************************
Public Function ReadIniFile_XtalProfitOfAmp() As String
    Dim strRtn As String
    Dim ret As Long
    
    strRtn = "                           "

    ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_AMP, DEF_XTAL_AMP, strRtn, Len(strRtn), INI_FILE)
    ReadIniFile_XtalProfitOfAmp = strRtn

End Function


